<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       piwebsolution.com
 * @since      1.0.0
 *
 * @package    Pisol_Mmq
 * @subpackage Pisol_Mmq/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Pisol_Mmq
 * @subpackage Pisol_Mmq/admin
 * @author     PI Websolution <sales@piwebsolution.com>
 */
class Pisol_Mmq_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		if(is_admin() && ! ( defined( 'DOING_AJAX' ) && DOING_AJAX )){
			new Pi_Mmq_Menu($this->plugin_name, $this->version);
			new Class_Pi_Mmq_Option($this->plugin_name);
			new Class_Pi_Mmq_Min_Amount($this->plugin_name);
			new Pisol_mmq_Design($this->plugin_name);
			new Class_Pi_Mmq_Min_Amount_Per_Cat($this->plugin_name);
			new Class_Pi_Mmq_Control($this->plugin_name);
			new Class_Pi_Mmq_Message($this->plugin_name);
			new Class_Pi_Mmq_Category($this->plugin_name);
			new Class_Pi_Mmq_Metabox();
		}
		add_action('admin_init', array($this,'plugin_redirect'));
	}

	function plugin_redirect(){
		if (get_option('pi_mmq_do_activation_redirect', false)) {
			delete_option('pi_mmq_do_activation_redirect');
			if(!isset($_GET['activate-multi']))
			{
				wp_redirect("admin.php?page=pisol-mmq-notification");
			}
		}
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Pisol_Mmq_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Pisol_Mmq_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/pisol-mmq-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Pisol_Mmq_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Pisol_Mmq_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/pisol-mmq-admin.js', array( 'jquery' ), $this->version, false );

		$min_quantity_enabled = (int)get_option('pi_mmq_min_quantity_enabled',0);
		$max_quantity_enabled = (int)get_option('pi_mmq_max_quantity_enabled',0);

		$data = array('min_quantity_enabled'=>$min_quantity_enabled, 'max_quantity_enabled'=>$max_quantity_enabled);
		
		wp_localize_script( $this->plugin_name, 'pi_mmq_settings', $data );
	}

}
